/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.wood;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.objects.inventory.capability.TFCInventoryLargeChest;
import net.dries007.tfc.objects.te.TEChestTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

@ParametersAreNonnullByDefault
public class BlockChestTFC
extends BlockChest
implements IItemSize {
    public static final BlockChest.Type TFCBASIC = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"TFCBASIC", (Class[])new Class[0], (Object[])new Object[0]);
    public static final BlockChest.Type TFCTRAP = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"TFCTRAP", (Class[])new Class[0], (Object[])new Object[0]);
    private static final Map<Tree, BlockChestTFC> MAP_BASIC = new HashMap<Tree, BlockChestTFC>();
    private static final Map<Tree, BlockChestTFC> MAP_TRAP = new HashMap<Tree, BlockChestTFC>();
    public final Tree wood;

    public static BlockChestTFC getBasic(Tree wood) {
        return MAP_BASIC.get((Object)wood);
    }

    public static BlockChestTFC getTrap(Tree wood) {
        return MAP_TRAP.get((Object)wood);
    }

    public BlockChestTFC(BlockChest.Type type, Tree wood) {
        super(type);
        this.wood = wood;
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        if (type == TFCBASIC) {
            if (MAP_BASIC.put(wood, this) != null) {
                throw new IllegalStateException("There can only be one.");
            }
            OreDictionaryHelper.register((Block)this, "chest");
            OreDictionaryHelper.register((Block)this, "chest", "wood");
            OreDictionaryHelper.register((Block)this, "chest", wood.getRegistryName().func_110623_a());
        } else if (type == TFCTRAP) {
            if (MAP_TRAP.put(wood, this) != null) {
                throw new IllegalStateException("There can only be one.");
            }
            OreDictionaryHelper.register((Block)this, "chest", "trapped");
            OreDictionaryHelper.register((Block)this, "chest", "wood");
            OreDictionaryHelper.register((Block)this, "chest", "trapped", wood.getRegistryName().func_110623_a());
        } else {
            throw new IllegalStateException("TFC Chest must use TFC chest type");
        }
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TFCGuiHandler.openGui(worldIn, pos, playerIn, TFCGuiHandler.Type.CHEST);
        }
        return true;
    }

    @Nullable
    public ILockableContainer func_189418_a(World worldIn, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityChest)) {
            return null;
        }
        Object ilockablecontainer = (TileEntityChest)tileentity;
        if (!allowBlocking && this.isBlocked(worldIn, pos)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = worldIn.func_180495_p(blockpos).func_177230_c();
            if (block != this) continue;
            if (!allowBlocking && this.isBlocked(worldIn, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new TFCInventoryLargeChest("container.chestDouble", (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityChest)tileentity1));
                continue;
            }
            ilockablecontainer = new TFCInventoryLargeChest("container.chestDouble", (ILockableContainer)((TileEntityChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TEChestTFC();
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.LIGHT;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }
}

